﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Data.SqlClient;
using Excel = Microsoft.Office.Interop.Excel;

namespace Formularz
{
    public partial class Form1 : Form
    {
        private DataSet dataSet = new DataSet();
        private BindingSource masterBindingSource = new BindingSource();
        private BindingSource detailBindingSource = new BindingSource();        

        Excel.Application xlApp;
        
        string nazwaPliku = "dane.xlsx";

        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            try
            {
                String connectionString =                 
                    @"Data Source = DAWID-HP\SQLEXPRESS;Initial Catalog=Northwind;Integrated Security = true";
                SqlConnection polaczenie = new SqlConnection(connectionString);                               
                
                // Pobranie danych i tworzenie tabel
                SqlDataAdapter customers = 
                    new SqlDataAdapter("SELECT * FROM Customers", polaczenie);
                customers.Fill(dataSet, "Customers");
                SqlDataAdapter orders = 
                    new SqlDataAdapter("SELECT * FROM Orders", polaczenie);
                orders.Fill(dataSet, "Orders");

                // Relacja miedzy tabelami
                DataRelation relacja = new DataRelation("CustomersOrders",
                    dataSet.Tables["Customers"].Columns["CustomerID"],
                    dataSet.Tables["Orders"].Columns["CustomerID"]);                
                dataSet.Relations.Add(relacja);
                
                masterBindingSource.DataSource = dataSet;
                masterBindingSource.DataMember = "Customers";

                // Wykorzystanie relacji do związania danych 
                // z komponentem DataGridView                
                detailBindingSource.DataSource = masterBindingSource;
                detailBindingSource.DataMember = "CustomersOrders";                
                dataGridView1.DataSource = detailBindingSource;

                // Wiązanie danych z kontrolka ComboBox
                comboBox1.DataSource = dataSet.Tables["Customers"];
                comboBox1.DisplayMember = "CompanyName";
            }
            catch (Exception ex)
            {
                MessageBox.Show("Wystąpił błąd połączenia :" + ex.Message);
            }            
        }

        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (comboBox1.SelectedIndex == -1)
                return;
            else
            {
                CurrencyManager cm = masterBindingSource.CurrencyManager;
                cm.Position = comboBox1.SelectedIndex;
            }
        }

        bool otworzPlikExcela(out Excel.Workbook wb, string sciezka = null)
        {
            // Jeśli Excel został wcześniej uruchomiony, 
            // to 'podłączamy' się do uruchomionej instancji.
            // W przeciwnym wypadku tworzymy nową instancję.
            try
            {
                xlApp = (Excel.Application)System.Runtime.InteropServices
                    .Marshal.GetActiveObject("Excel.Application");
            }
            catch (Exception ex)
            {
                xlApp = new Microsoft.Office.Interop.Excel.Application();
            }
            
            wb = null;

            if (sciezka != null)
            {
                try
                {
                    wb = xlApp.Workbooks.Open(sciezka);
                }
                catch (Exception ex)
                {
                    try
                    {
                        wb = (Excel.Workbook)System.Runtime.InteropServices
                            .Marshal.BindToMoniker(sciezka);
                    }
                    catch (Exception ex1)
                    {                        
                        return false;
                    }
                }
            }
           
            return true;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            if (openFileDialog1.ShowDialog() != System.Windows.Forms.DialogResult.OK)
            {
                MessageBox.Show("Wybierz poprawną ścieżkę do eksportu danych");
                return;
            }
            else if (!openFileDialog1.CheckFileExists)
            {
                MessageBox.Show("Podany plik " + openFileDialog1.FileName
                    + " nie istnieje");
                return;
            }

            Excel.Workbook wb = null;
            if (!otworzPlikExcela(out wb, openFileDialog1.FileName))
            {
                MessageBox.Show("Próba otwarcia pliku:\n" +
                    openFileDialog1.FileName +
                    "\nNie powiodła się", "Formularz");
            }

            // Przygotowanie wiersza nagłówka
            string wierszNaglowka = "";
            for (int i = 0; i < dataGridView1.ColumnCount; i++)
                wierszNaglowka += dataGridView1.Columns[i].Name + "\t";

            wierszNaglowka += "\n";

            // Przygotowanie eksportowanych danych
            string daneDoWstawienia = "";
            foreach (DataGridViewRow wiersz in dataGridView1.Rows)
            {
                foreach (DataGridViewCell komorka in wiersz.Cells)
                    daneDoWstawienia += komorka.Value + "\t";

                daneDoWstawienia += '\n';
            }

            // Kopiowanie danych do schowka
            Clipboard.SetDataObject(wierszNaglowka + daneDoWstawienia);

            // Pobranie pierwszego arkusza
            Excel.Worksheet ws = (Excel.Worksheet)wb.Worksheets.get_Item(1);

            // Wklejenie zawartości schowka rozpoczynając od komórki A1
            Excel.Range adres = ws.get_Range("A1");
            ws.Paste(adres, daneDoWstawienia);

            // Zapis pliku i zakończenie połączenia z Excelem
            wb.Save();
            xlApp.Quit();
            System.Runtime.InteropServices.Marshal.ReleaseComObject(xlApp);

            MessageBox.Show("Pomyślnie wyeksportowano dane do pliku:\n"
                + openFileDialog1.FileName,
                "Formularz");            
        }

        bool podlaczDoExcela()
        {
            Excel.Workbook wb = null;
            return otworzPlikExcela(out wb);
        }

        private void button2_Click(object sender, EventArgs e)
        {
            if (folderBrowserDialog1.ShowDialog() != System.Windows.Forms.DialogResult.OK)
            {
                MessageBox.Show("Wybierz poprawną ścieżkę do eksportu danych");
                return;
            }
            
            if (!podlaczDoExcela())
            {
                MessageBox.Show("Próba eksportu danych nie powiodła się" , "Formularz");
                return;
            }
            
            xlApp.Workbooks.Add();
            Excel.Workbook wb = xlApp.Workbooks.get_Item(1);
            Excel.Worksheet ws = wb.Worksheets.get_Item(1);

            // Tablica zawierająca dane do przeniesienia, w której 
            // dodatkowy wiersz przeznaczono na nagłówek tabeli
            object[,] daneDoWstawienia = 
                new Object[dataGridView1.RowCount + 1, dataGridView1.ColumnCount];
 
            for(int i = 0; i < dataGridView1.RowCount; i++)
                for (int j = 0; j < dataGridView1.ColumnCount; j++)
                {
                    if(i == 0)
                        daneDoWstawienia[i, j] = dataGridView1.Columns[j].Name;
                    else
                        daneDoWstawienia[i, j] = dataGridView1.Rows[i - 1].Cells[j].Value;
                }

            Excel.Range adres = ws.get_Range("A1");         
   
            // Dopasowanie docelowego zakresu komórek do rozmiarów tablicy daneDoWstawienia
            adres = adres.get_Resize(dataGridView1.RowCount + 1, dataGridView1.ColumnCount);
            adres.Value = daneDoWstawienia;
    
            string sciezka = folderBrowserDialog1.SelectedPath;

            if (sciezka.EndsWith("\\"))
                sciezka += nazwaPliku;
            else
                sciezka += "\\" + nazwaPliku;

            wb.SaveAs(sciezka);            
            wb.Close();
            xlApp.Quit();
            System.Runtime.InteropServices.Marshal.ReleaseComObject(xlApp);
            
            MessageBox.Show("Pomyślnie wyeksportowano dane do pliku:\n"
                + sciezka, "Formularz");   
        }

        private void button3_Click(object sender, EventArgs e)
        {
            if (folderBrowserDialog1.ShowDialog() != System.Windows.Forms.DialogResult.OK)
            {
                MessageBox.Show("Wybierz poprawną ścieżkę do eksportu danych");
                return;
            }

            if (!podlaczDoExcela())
            {
                MessageBox.Show("Próba eksportu danych nie powiodła się", "Formularz");
                return;
            }

            // Tworzenie tymczasowego pliku XML
            string plikTymczasowy = "temp.xml";
            System.IO.FileStream fs =
                new System.IO.FileStream(plikTymczasowy, System.IO.FileMode.Create);            
            
            // Zapis pierwszej tabeli do tymczasowego pliku XML
            dataSet.Tables[0].WriteXml(fs);
            fs.Close();

            // Wyłączenie wyświetlania komunikatów Excela i otwarcie pliku XML
            object missing = System.Type.Missing;            
            xlApp.DisplayAlerts = false;
            
            Excel.Workbook wb =
                xlApp.Workbooks.OpenXML(System.IO.Path.GetFullPath(plikTymczasowy), 
                missing, Excel.XlXmlLoadOption.xlXmlLoadImportToList);
                        
            // Zapis pliku w formacie Excela
            string sciezka = folderBrowserDialog1.SelectedPath;
            
            if(sciezka.EndsWith("\\"))
                sciezka +=  nazwaPliku;            
            else
                sciezka += "\\" + nazwaPliku;

            if (System.IO.File.Exists(sciezka))
                sciezka = sciezka.Replace(".xlsx", DateTime.Now.Second.ToString() + ".xlsx");

            wb.SaveAs(sciezka);
            wb.Close();
            xlApp.Quit();                        
            System.Runtime.InteropServices.Marshal.ReleaseComObject(xlApp);

            // Usunięcie pliku tymczasowego
            System.IO.File.Delete(plikTymczasowy);
            
            MessageBox.Show("Pomyślnie wyeksportowano dane do pliku: " +
                sciezka, "Formularz");
        }

        private void button4_Click(object sender, EventArgs e)
        {
            if (folderBrowserDialog1.ShowDialog() != System.Windows.Forms.DialogResult.OK)
            {
                MessageBox.Show("Wybierz poprawną ścieżkę do eksportu danych");
                return;
            }

            if (!podlaczDoExcela())
            {
                MessageBox.Show("Próba eksportu danych nie powiodła się", "Formularz");
                return;
            }

            string nazwaPlikuHTML = nazwaPliku.Replace(".xlsx", ".html");
            // Tworzenie tymczasowego pliku XML
            string plikTymczasowy = "temp.xml";
            System.IO.FileStream fs =
                new System.IO.FileStream(plikTymczasowy, System.IO.FileMode.Create);

            // Zapis pierwszej tabeli do tymczasowego pliku XML
            dataSet.Tables[0].WriteXml(fs);            
            fs.Close();

            // Wyłączenie wyświetlania komunikatów Excela i otwarcie pliku XML
            object missing = System.Type.Missing;
            xlApp.DisplayAlerts = false;

            Excel.Workbook wb =
                xlApp.Workbooks.OpenXML(System.IO.Path.GetFullPath(plikTymczasowy),
                missing, Excel.XlXmlLoadOption.xlXmlLoadImportToList);

            // Zapis pliku w formacie Excela
            string sciezka = folderBrowserDialog1.SelectedPath;

            if (sciezka.EndsWith("\\"))
                sciezka += nazwaPlikuHTML;
            else
                sciezka += "\\" + nazwaPlikuHTML;

            wb.SaveAs(sciezka, Excel.XlFileFormat.xlHtml);            
            wb.Close();
            xlApp.Quit();
            System.Runtime.InteropServices.Marshal.ReleaseComObject(xlApp);
            
            // Usunięcie pliku tymczasowego
            System.IO.File.Delete(plikTymczasowy);

            MessageBox.Show("Pomyślnie wyeksportowano dane do pliku: " +
                sciezka, "Formularz");
        }

        private void button5_Click(object sender, EventArgs e)
        {
            Microsoft.Reporting.WinForms.LocalReport rp =
                new Microsoft.Reporting.WinForms.LocalReport();

            Microsoft.Reporting.WinForms.ReportDataSource rpDataSource =
                new Microsoft.Reporting.WinForms.ReportDataSource("dane", dataGridView1.DataSource);
            
            rp.DataSources.Add(rpDataSource);
            System.IO.Stream fs = new System.IO.FileStream("Report1.rdlc", System.IO.FileMode.Open);
            rp.LoadReportDefinition(fs);
            byte[] danePDF = rp.Render("PDF"); 
        }
    }
}
